package ru.yandex.direct.logviewercore.service.virtual;

import java.util.List;

import ru.yandex.direct.logviewercore.domain.ppclog.LogRecord;

/**
 * Вычисление "виртуальной" колонки по нескольким исходным
 *
 * @param <L> - тип лога
 * @param <T> - тип "виртуальной" колонки
 */
public interface VirtualColumn<L extends LogRecord, T> {
    /**
     * исходные колонки (нужные для вычисления)
     */
    String[] sourceColumns();

    /**
     * массовое вычисление колонок, запись в recs
     */
    void calculate(List<L> recs);
}
