package ru.yandex.direct.market.client

import ru.yandex.direct.dbutil.model.ClientId

/**
 * Интерфейс клиента-обёртки над api-сервисами Маркета.
 */
interface MarketClient {
    data class SendFeedResult(val marketFeedId: Long, val shopId: Long, val businessId: Long)

    data class UrlFeedInfo(val clientId: ClientId,
                           val chiefUid: Long,
                           val feedId: Long,
                           val feedUrl: String,
                           val login: String?,
                           val password: String?)

    fun sendUrlFeedToMbi(urlFeedInfo: UrlFeedInfo, enableDirectPlacement: Boolean? = null): SendFeedResult


    enum class Schema { HTTP, HTTPS }

    data class SiteFeedInfo(val clientId: ClientId,
                            val chiefUid: Long,
                            val feedId: Long,
                            val schema: Schema,
                            val domain: String)

    fun sendSiteFeedToMbi(siteFeedInfo: SiteFeedInfo, enableDirectPlacement: Boolean? = null): SendFeedResult


    data class FileFeedInfo(val clientId: ClientId,
                            val chiefUid: Long,
                            val feedId: Long,
                            val fileMdsUrl: String,
                            val refresh: Boolean)

    fun sendFileFeedToMbi(fileFeedInfo: FileFeedInfo, enableDirectPlacement: Boolean? = null): SendFeedResult

    data class SitePreviewInfo(val schema: Schema,
                               val domain: String,
                               val numOffers: Int)

    fun addSitePreviewToMBI(sitePreviewInfo: SitePreviewInfo): SendFeedResult

    data class SitePreviewIds(val shopId: Long,
                              val feedId: Long)

    fun deleteSitePreviewsFromMBI(deleteSitePreviewInfo: List<SitePreviewIds>): List<SitePreviewIds>

    data class FeedFeaturesInfo(val shopId: Long,
                                val isStandby: Boolean,
                                val isGoodsAds: Boolean,
                                val isSearchSnippetGallery: Boolean)

    fun setFeedFeaturesToMbi(feedFeaturesInfo: FeedFeaturesInfo)

}
