package ru.yandex.direct.mysql2grut.enummappers

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroupDeviceTypeTargeting
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroupNetworkTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLang
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting.ETargetingType
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting.ETargetingMode
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting.EValueJoinType
import ru.yandex.grut.objects.proto.AdGroupAdditionalTargeting.TAdGroupAdditionalTargeting.EInterfaceLanguage
import ru.yandex.grut.objects.proto.AdGroupV2
import ru.yandex.grut.objects.proto.AdGroupV2.TAdGroupV2Spec.TMobileContentDetails.EDeviceType
import ru.yandex.grut.objects.proto.AdGroupV2.TAdGroupV2Spec.TMobileContentDetails.ENetworkType
import ru.yandex.grut.objects.proto.RelevanceMatchCategory.ERelevanceMatchCategory

/**
 * Маппинги для групп
 */
class AdGroupEnumMappers {
    companion object {
        val RELEVANCE_MATCH_MAPPER = mapOf(
            RelevanceMatchCategory.exact_mark to ERelevanceMatchCategory.RMC_EXACT_MARK,
            RelevanceMatchCategory.alternative_mark to ERelevanceMatchCategory.RMC_ALTERNATIVE_MARK,
            RelevanceMatchCategory.competitor_mark to ERelevanceMatchCategory.RMC_COMPETITOR_MARK,
            RelevanceMatchCategory.broader_mark to ERelevanceMatchCategory.RMC_BROADER_MARK,
            RelevanceMatchCategory.accessory_mark to ERelevanceMatchCategory.RMC_ACCESSORY_MARK,
        )

        fun toGrutRelevanceMatchCategory(category: RelevanceMatchCategory): ERelevanceMatchCategory {
            return convert(
                RELEVANCE_MATCH_MAPPER,
                ERelevanceMatchCategory.RMC_UNKNOWN,
                category
            )
        }

        val AD_GROUP_TYPE_MAPPER = buildEnumMapping(
            AdGroupType::class.java, AdGroupV2.EAdGroupType::class.java, mapOf(
            AdGroupType.PERFORMANCE to AdGroupV2.EAdGroupType.AGT_SMART,
            AdGroupType.MCBANNER to AdGroupV2.EAdGroupType.AGT_MEDIA_CONTEXT,
            AdGroupType.CPM_BANNER to AdGroupV2.EAdGroupType.AGT_CPM,
        )
        )

        fun toGrutAdGroupType(type: AdGroupType): AdGroupV2.EAdGroupType {
            return convert(AD_GROUP_TYPE_MAPPER, AdGroupV2.EAdGroupType.AGT_UNKNOWN, type)
        }

        val TARGETING_MODE_MAPPER = buildEnumMapping(AdGroupAdditionalTargetingMode::class.java, ETargetingMode::class.java)
        fun toGrutTargetingMode(mode: AdGroupAdditionalTargetingMode): ETargetingMode {
            return convert(TARGETING_MODE_MAPPER, ETargetingMode.TM_UNKNOWN, mode)
        }

        val JOIN_TYPE_MAPPER = buildEnumMapping(AdGroupAdditionalTargetingJoinType::class.java, EValueJoinType::class.java)
        fun toGrutJoinType(joinType: AdGroupAdditionalTargetingJoinType): EValueJoinType {
            return convert(JOIN_TYPE_MAPPER, EValueJoinType.JT_UNKNOWN, joinType)
        }

        val TARGETING_TYPE_MAPPER = buildEnumMapping(
            AdgroupAdditionalTargetingsTargetingType::class.java,
            ETargetingType::class.java,
            mapOf(
                AdgroupAdditionalTargetingsTargetingType.query_referers to ETargetingType.TT_QUERY_REFERRERS,
                AdgroupAdditionalTargetingsTargetingType.internal_test_ids to ETargetingType.TT_TEST_IDS
            ),
        )

        fun toGrutTargetingType(targetingType: AdgroupAdditionalTargetingsTargetingType): ETargetingType {
            return convert(TARGETING_TYPE_MAPPER, ETargetingType.TT_UNKNOWN, targetingType)
        }

        val INTERFACE_LANG_MAPPER = buildEnumMapping(InterfaceLang::class.java, EInterfaceLanguage::class.java)
        fun toGrutInterfaceLanguage(interfaceLang: InterfaceLang): EInterfaceLanguage {
            return convert(INTERFACE_LANG_MAPPER, EInterfaceLanguage.IL_UNKNOWN, interfaceLang)
        }

        val DEVICE_TYPE_MAPPER = buildEnumMapping(MobileContentAdGroupDeviceTypeTargeting::class.java, EDeviceType::class.java)
        fun toGrutMobileDeviceType(deviceTypeTargeting: MobileContentAdGroupDeviceTypeTargeting): EDeviceType {
            return convert(DEVICE_TYPE_MAPPER, EDeviceType.DV_UNKNOWN, deviceTypeTargeting)
        }

        val NETWORK_TYPE_MAPPER = buildEnumMapping(MobileContentAdGroupNetworkTargeting::class.java, ENetworkType::class.java)
        fun toGrutMobileNetworkType(networkTargeting: MobileContentAdGroupNetworkTargeting): ENetworkType {
            return convert(NETWORK_TYPE_MAPPER, ENetworkType.NT_UNKNOWN, networkTargeting)
        }
    }
}
