package ru.yandex.direct.mysql2grut.enummappers

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner
import ru.yandex.direct.core.entity.banner.model.CpmBanner
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner
import ru.yandex.direct.core.entity.banner.model.DynamicBanner
import ru.yandex.direct.core.entity.banner.model.ImageBanner
import ru.yandex.direct.core.entity.banner.model.ImageType
import ru.yandex.direct.core.entity.banner.model.InternalBanner
import ru.yandex.direct.core.entity.banner.model.McBanner
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner
import ru.yandex.direct.core.entity.banner.model.NewMobileContentPrimaryAction
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain
import ru.yandex.direct.core.entity.banner.model.TextBanner
import ru.yandex.direct.core.entity.image.model.AvatarHost
import ru.yandex.grut.auxiliary.proto.MdsInfo
import ru.yandex.grut.objects.proto.BannerV2
import ru.yandex.grut.objects.proto.BannerV2.TBannerV2Spec
import ru.yandex.grut.objects.proto.Language

class BannerEnumMappers {

    companion object {
        fun toGrutBannerType(banner: BannerWithSystemFields): BannerV2.EBannerType = when (banner) {
            is TextBanner -> BannerV2.EBannerType.BT_TEXT
            is CpmBanner -> BannerV2.EBannerType.BT_CPM
            is DynamicBanner -> BannerV2.EBannerType.BT_DYNAMIC
            is PerformanceBanner -> BannerV2.EBannerType.BT_SMART
            is ImageBanner -> BannerV2.EBannerType.BT_IMAGE_AD
            is MobileAppBanner -> BannerV2.EBannerType.BT_MOBILE_CONTENT
            is McBanner -> BannerV2.EBannerType.BT_MEDIA_CONTEXT
            is CpcVideoBanner -> BannerV2.EBannerType.BT_CPC_VIDEO
            is CpmOutdoorBanner -> BannerV2.EBannerType.BT_CPM_OUTDOOR
            is CpmIndoorBanner -> BannerV2.EBannerType.BT_CPM_INDOOR
            is InternalBanner -> BannerV2.EBannerType.BT_INTERNAL
            is CpmAudioBanner -> BannerV2.EBannerType.BT_CPM_AUDIO
            is ContentPromotionBanner -> BannerV2.EBannerType.BT_CONTENT_PROMOTION
            is PerformanceBannerMain -> BannerV2.EBannerType.BT_SMART_MAIN
            else -> BannerV2.EBannerType.BT_UNKNOWN
        }

        private val LANGUAGE_MAPPER = buildEnumMapping(
            ru.yandex.direct.core.entity.banner.model.Language::class.java, Language.ELanguage::class.java,
        )

        fun toGrutLanguage(language: ru.yandex.direct.core.entity.banner.model.Language): Language.ELanguage {
            return convert(
                LANGUAGE_MAPPER,
                Language.ELanguage.LANG_UNKNOWN,
                language
            )
        }

        private val PRIMARY_ACTION_MAPPER = buildEnumMapping(
            NewMobileContentPrimaryAction::class.java,
            TBannerV2Spec.TMobileContent.EPrimaryAction::class.java
        )

        fun toGrutPrimaryAction(primaryAction: NewMobileContentPrimaryAction):
                TBannerV2Spec.TMobileContent.EPrimaryAction {
            return convert(
                PRIMARY_ACTION_MAPPER,
                TBannerV2Spec.TMobileContent.EPrimaryAction.PA_UNKNOWN,
                primaryAction
            )
        }

        private val IMAGE_TYPE_MAPPER = buildEnumMapping(
            ImageType::class.java, TBannerV2Spec.TImage.EImageType::class.java
        )

        fun imageTypeToGrut(imageType: ImageType): TBannerV2Spec.TImage.EImageType {
            return convert(IMAGE_TYPE_MAPPER, TBannerV2Spec.TImage.EImageType.IT_UNKNOWN, imageType)
        }

        private val AVATARS_HOST_MAPPER = mapOf(
            AvatarHost.AVATARS_MDS_YANDEX_NET to MdsInfo.TMdsFileInfo.EEnvironment.ENV_PRODUCTION,
            AvatarHost.AVATARS_MDST_YANDEX_NET to MdsInfo.TMdsFileInfo.EEnvironment.ENV_TEST
        )

        fun avatarsHostToEnvironment(avatarHost: AvatarHost): MdsInfo.TMdsFileInfo.EEnvironment {
            return convert(
                AVATARS_HOST_MAPPER,
                MdsInfo.TMdsFileInfo.EEnvironment.ENV_UNKNOWN,
                avatarHost
            )
        }
    }
}
