package ru.yandex.direct.mysql2grut.enummappers

import org.slf4j.LoggerFactory
import ru.yandex.direct.core.entity.bidmodifier.AgeType
import ru.yandex.direct.core.entity.bidmodifier.BannerType
import ru.yandex.direct.core.entity.bidmodifier.GenderType
import ru.yandex.direct.core.entity.bidmodifier.InventoryType
import ru.yandex.direct.core.entity.bidmodifier.OperationType
import ru.yandex.direct.core.entity.bidmodifier.OsType
import ru.yandex.direct.core.entity.bidmodifier.TabletOsType
import ru.yandex.direct.core.entity.bidmodifier.TrafaretPosition
import ru.yandex.direct.core.entity.bidmodifier.WeatherType
import ru.yandex.direct.core.entity.bidmodifier.model.BidModifierExpressionOperator
import ru.yandex.direct.dbschema.ppc.enums.HierarchicalMultipliersType
import ru.yandex.grut.auxiliary.proto.YabsOperation
import ru.yandex.grut.objects.proto.AgeGroup.EAgeGroup
import ru.yandex.grut.objects.proto.BidModifier.EBidModifierType
import ru.yandex.grut.objects.proto.BidModifier.TBidModifierSpec.EPosition
import ru.yandex.grut.objects.proto.BidModifier.TBidModifierSpec.EWeatherParameter
import ru.yandex.grut.objects.proto.Gender
import ru.yandex.grut.objects.proto.InventoryType.EInventoryType
import ru.yandex.grut.objects.proto.MobilePlatform.EMobilePlatform

class BidModifierEnumMappers {
    companion object Mappers {
        private val logger = LoggerFactory.getLogger(Mappers::class.java)

        private val BID_MODIFIER_TYPE_MAPPER = buildEnumMapping(
            HierarchicalMultipliersType::class.java, EBidModifierType::class.java,
            mapOf(
                HierarchicalMultipliersType.mobile_multiplier to EBidModifierType.MLT_MOBILE,
                HierarchicalMultipliersType.demography_multiplier to EBidModifierType.MLT_DEMOGRAPHY,
                HierarchicalMultipliersType.retargeting_multiplier to EBidModifierType.MLT_RETARGETING,
                HierarchicalMultipliersType.geo_multiplier to EBidModifierType.MLT_GEO,
                HierarchicalMultipliersType.video_multiplier to EBidModifierType.MLT_VIDEO,
                HierarchicalMultipliersType.performance_tgo_multiplier to EBidModifierType.MLT_PERFORMANCE_TGO,
                HierarchicalMultipliersType.ab_segment_multiplier to EBidModifierType.MLT_AB_SEGMENT,
                HierarchicalMultipliersType.banner_type_multiplier to EBidModifierType.MLT_INVENTORY,
                HierarchicalMultipliersType.inventory_multiplier to EBidModifierType.MLT_INVENTORY,
                HierarchicalMultipliersType.desktop_multiplier to EBidModifierType.MLT_DESKTOP,
                HierarchicalMultipliersType.weather_multiplier to EBidModifierType.MLT_WEATHER,
                HierarchicalMultipliersType.trafaret_position_multiplier to EBidModifierType.MLT_TRAFARET_POSITION,
                HierarchicalMultipliersType.prisma_income_grade_multiplier to EBidModifierType.MLT_PRISMA_INCOME_GRADE,
                HierarchicalMultipliersType.retargeting_filter to EBidModifierType.MLT_RETARGETING_FILTER,
                HierarchicalMultipliersType.smarttv_multiplier to EBidModifierType.MLT_SMARTTV,
                HierarchicalMultipliersType.tablet_multiplier to EBidModifierType.MLT_TABLET,
                HierarchicalMultipliersType.desktop_only_multiplier to EBidModifierType.MLT_DESKTOP_ONLY,
            )
        )

        fun toGrut(type: HierarchicalMultipliersType): EBidModifierType {
            return convert(BID_MODIFIER_TYPE_MAPPER, EBidModifierType.MLT_UNKNOWN, type)
        }

        private val MOBILE_PLATFORM_MAPPER = buildEnumMapping(OsType::class.java, EMobilePlatform::class.java)
        fun toGrut(type: OsType?): EMobilePlatform {
            if (type == null) return EMobilePlatform.MP_UNKNOWN
            return convert(MOBILE_PLATFORM_MAPPER, EMobilePlatform.MP_UNKNOWN, type)
        }

        private val AGE_GROUP_MAPPING = mapOf(
            AgeType._0_17 to EAgeGroup.AG_0_17,
            AgeType._18_24 to EAgeGroup.AG_18_24,
            AgeType._25_34 to EAgeGroup.AG_25_34,
            AgeType._35_44 to EAgeGroup.AG_35_44,
            AgeType._45_54 to EAgeGroup.AG_45_54,
            AgeType._55_ to EAgeGroup.AG_55_,
        )

        fun toGrut(age: AgeType?): EAgeGroup {
            return when (age) {
                null -> EAgeGroup.AG_UNKNOWN
                AgeType._45_, AgeType.UNKNOWN -> {
                    logger.error("Converting unsupported age type: $age")
                    return EAgeGroup.AG_UNKNOWN
                }
                else -> AGE_GROUP_MAPPING[age]!!
            }
        }

        private val TABLET_PLATFORM_MAPPER = buildEnumMapping(TabletOsType::class.java, EMobilePlatform::class.java)
        fun toGrut(type: TabletOsType?): EMobilePlatform {
            if (type == null) return EMobilePlatform.MP_UNKNOWN
            return convert(TABLET_PLATFORM_MAPPER, EMobilePlatform.MP_UNKNOWN, type)
        }

        private val GENDER_MAPPER = buildEnumMapping(GenderType::class.java, Gender.EGender::class.java)
        fun toGrut(gender: GenderType?): Gender.EGender {
            if (gender == null) return Gender.EGender.G_UNKNOWN
            return convert(GENDER_MAPPER, Gender.EGender.G_UNKNOWN, gender)
        }

        fun toGrut(op: OperationType): YabsOperation.EYabsOperation {
            return when (op) {
                OperationType.EQ -> YabsOperation.EYabsOperation.YO_EQUAL
                OperationType.GE -> YabsOperation.EYabsOperation.YO_GREATER_OR_EQUAL
                OperationType.LE -> YabsOperation.EYabsOperation.YO_LESS_OR_EQUAL
            }
        }

        fun toGrut(op: BidModifierExpressionOperator): YabsOperation.EYabsOperation {
            return when (op) {
                BidModifierExpressionOperator.EQ -> YabsOperation.EYabsOperation.YO_EQUAL
                BidModifierExpressionOperator.GE -> YabsOperation.EYabsOperation.YO_GREATER_OR_EQUAL
                BidModifierExpressionOperator.LE -> YabsOperation.EYabsOperation.YO_LESS_OR_EQUAL
                BidModifierExpressionOperator.GT -> YabsOperation.EYabsOperation.YO_GREATER
                BidModifierExpressionOperator.LT -> YabsOperation.EYabsOperation.YO_LESS
                BidModifierExpressionOperator.NE -> YabsOperation.EYabsOperation.YO_NOT_EQUAL
                BidModifierExpressionOperator.MATCH_GOAL_CONTEXT -> YabsOperation.EYabsOperation.YO_MATCH_GOAL_CONTEXT
            }
        }

        fun toGrut(parameter: WeatherType): EWeatherParameter {
            return when (parameter) {
                WeatherType.TEMP -> EWeatherParameter.WT_TEMPERATURE
                WeatherType.CLOUDNESS -> EWeatherParameter.WT_CLOUDNESS
                WeatherType.PREC_STRENGTH -> EWeatherParameter.WT_PRECIPATION_STRENGTH
            }
        }

        fun toGrut(type: BannerType): EInventoryType {
            val result = when (type) {
                BannerType.CPM_BANNER -> EInventoryType.IT_ALL_BANNERS
                // Больше не поддерживаются, в данных и в коде их нет.
                BannerType.CPM_VIDEO -> EInventoryType.IT_UNKNOWN
                BannerType.CPM_OUTDOOR -> EInventoryType.IT_UNKNOWN
            }
            if (result == EInventoryType.IT_UNKNOWN) {
                logger.error("Unsupported bannerType: $type")
            }
            return result
        }

        private val INVENTORY_TYPE_MAPPER = buildEnumMapping(
            InventoryType::class.java,
            EInventoryType::class.java,
            mapOf(InventoryType.INSTREAM_WEB to EInventoryType.IT_INSTREAM),
        )

        fun toGrut(type: InventoryType): EInventoryType {
            return convert(INVENTORY_TYPE_MAPPER, EInventoryType.IT_UNKNOWN, type)
        }

        fun toGrut(type: TrafaretPosition): EPosition {
            return when (type) {
                TrafaretPosition.ALONE -> EPosition.POS_ALONE
                TrafaretPosition.SUGGEST -> EPosition.POS_SUGGEST
            }
        }
    }
}
