package ru.yandex.direct.mysql2grut.enummappers

import ru.yandex.direct.autobudget.restart.service.Reason
import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel
import ru.yandex.direct.core.entity.campaign.model.CampaignMetatype
import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType
import ru.yandex.direct.core.entity.campaign.model.InternalCampaignRestrictionType
import ru.yandex.direct.core.entity.campaign.model.RfCloseByClickType
import ru.yandex.direct.core.entity.campaign.model.StrategyName
import ru.yandex.direct.core.entity.product.model.ProductType
import ru.yandex.grut.objects.proto.CampaignPlatform
import ru.yandex.grut.objects.proto.CampaignV2
import ru.yandex.grut.objects.proto.CampaignV2.TCampaignV2Spec.TAutoBudgetRestart.ERestartReason
import ru.yandex.grut.objects.proto.CampaignV2.TCampaignV2Spec.TStrategy
import ru.yandex.grut.objects.proto.Client.EProductType

class CampaignEnumMappers {
    companion object {
        val CAMPAIGN_TYPE_BLACKLIST: Set<CampaignType> = setOf(
            CampaignType.GEO,   // quickfix for DIRECT-160062
            CampaignType.MCB,   // старый баян, закрыт как продукт
            CampaignType.BILLING_AGGREGATE,  // не реплицируем как кампанию, складываем данные внутрь клиента
        )

        val CAMPAIGN_TYPE_MAPPER = buildEnumMapping(
            CampaignType::class.java, CampaignV2.ECampaignType::class.java, mapOf(
                CampaignType.PERFORMANCE to CampaignV2.ECampaignType.CT_SMART,
                CampaignType.MCBANNER to CampaignV2.ECampaignType.CT_MEDIA_CONTEXT,
                CampaignType.CPM_BANNER to CampaignV2.ECampaignType.CT_CPM,

                )
        )

        val PRODUCT_TYPE_MAPPER = buildEnumMapping(
            ProductType::class.java,
            EProductType::class.java,
        )

        fun toGrutCampaignType(type: CampaignType): CampaignV2.ECampaignType {
            return convert(
                CAMPAIGN_TYPE_MAPPER,
                CampaignV2.ECampaignType.CT_UNKNOWN,
                type
            )
        }

        // ProductType.AUTO_IMPORT пока не поддержан
        fun toGrutProductType(productType: ProductType): EProductType {
            return convert(
                PRODUCT_TYPE_MAPPER,
                EProductType.PT_UNKNOWN,
                productType,
            )
        }

        private val CAMPAIGN_METATYPE_MAPPER = buildEnumMapping(
            CampaignMetatype::class.java, CampaignV2.ECampaignMetaType::class.java
        )

        fun toGrutCampaignMetatype(metatype: CampaignMetatype): CampaignV2.ECampaignMetaType {
            return convert(
                CAMPAIGN_METATYPE_MAPPER,
                CampaignV2.ECampaignMetaType.CM_UNKNOWN,
                metatype
            )
        }

        private val STRATEGY_NAME_MAPPER =
            buildEnumMapping(StrategyName::class.java, TStrategy.EStrategyType::class.java)

        private val PLATFORM_MAPPER = buildEnumMapping(
            CampaignsPlatform::class.java, CampaignPlatform.ECampaignPlatform::class.java,
            mapOf(
                CampaignsPlatform.CONTEXT to CampaignPlatform.ECampaignPlatform.CP_PARTNER
            )
        )
        private val PLATFORM_MAPPER_FROM_GRUT =
            buildEnumMapping(
                CampaignPlatform.ECampaignPlatform::class.java, CampaignsPlatform::class.java,
                mapOf(
                    CampaignPlatform.ECampaignPlatform.CP_PARTNER to CampaignsPlatform.CONTEXT
                )
            )

        private val STRATEGY_NAME_MAPPER_FROM_GRUT =
            buildEnumMapping(TStrategy.EStrategyType::class.java, StrategyName::class.java)

        fun toGrutStrategyType(strategyName: StrategyName): TStrategy.EStrategyType {
            return convert(STRATEGY_NAME_MAPPER, TStrategy.EStrategyType.ST_UNKNOWN, strategyName)
        }

        fun fromGrutStrategyType(number: Int): StrategyName? {
            val strategyType = TStrategy.EStrategyType.forNumber(number)
            return convertWithDefaultNull(STRATEGY_NAME_MAPPER_FROM_GRUT, strategyType)
        }

        private val ATTRIBUTION_MODEL_MAPPER =
            buildEnumMapping(CampaignAttributionModel::class.java, CampaignV2.ECampaignAttribution::class.java)

        fun toGrutAttributionModel(attributionModel: CampaignAttributionModel): CampaignV2.ECampaignAttribution =
            convert(ATTRIBUTION_MODEL_MAPPER, CampaignV2.ECampaignAttribution.CA_UNKNOWN, attributionModel)

        private val SOURCE_MAPPER = buildEnumMapping(CampaignSource::class.java, CampaignV2.ECampaignSource::class.java)

        fun toGrutSource(source: CampaignSource): CampaignV2.ECampaignSource =
            convert(SOURCE_MAPPER, CampaignV2.ECampaignSource.CSR_UNKNOWN, source)

        fun toGrutPlatform(platform: CampaignsPlatform): CampaignPlatform.ECampaignPlatform =
            convert(PLATFORM_MAPPER, CampaignPlatform.ECampaignPlatform.CP_UNKNOWN, platform)

        fun fromGrutPlatform(platformNumber: Int): CampaignsPlatform? {
            val platform = CampaignPlatform.ECampaignPlatform.forNumber(platformNumber);
            return convertWithDefaultNull(PLATFORM_MAPPER_FROM_GRUT, platform)
        }

        private val autobudgetRestartReasonFromGrutMapper = mapOf(
            ERestartReason.RR_INIT to Reason.INIT,
            ERestartReason.RR_EMPTY to Reason.EMPTY,
            ERestartReason.RR_BS_RESTART to Reason.BS_RESTART,
            ERestartReason.RR_AUTOBUDGET_START to Reason.AUTOBUDGET_START,
            ERestartReason.RR_DAY_BUDGET_START to Reason.DAY_BUDGET_START,
            ERestartReason.RR_DAY_BUDGET_CHANGED to Reason.DAY_BUDGET_CHANGED,
            ERestartReason.RR_CHANGED_PAID_ACTION to Reason.CHANGED_PAID_ACTION,
            ERestartReason.RR_SUM_CHANGED_FOR_PAID_ACTIONS to Reason.SUM_CHANGED_FOR_PAID_ACTIONS,
            ERestartReason.RR_OPTIMIZE_TYPE_CHANGED to Reason.OPTIMIZE_TYPE_CHANGED,
            ERestartReason.RR_CHANGED_START_TIME_TO_PAST to Reason.CHANGED_START_TIME_TO_PAST,
            ERestartReason.RR_CHANGED_START_TIME_TO_FUTURE to Reason.CHANGED_START_TIME_TO_FUTURE,
            ERestartReason.RR_START_TIME_IN_FUTURE to Reason.START_TIME_IN_FUTURE,
            ERestartReason.RR_CHANGED_TIME_TARGET to Reason.CHANGED_TIME_TARGET,
            ERestartReason.RR_CHANGED_AUTOBUDGET_SUM to Reason.CHANGED_AUTOBUDGET_SUM,
            ERestartReason.RR_CHANGED_AUTOBUDGET_BID to Reason.CHANGED_AUTOBUDGET_BID,
            ERestartReason.RR_CHANGED_LIMIT_CLICKS to Reason.CHANGED_LIMIT_CLICKS,
            ERestartReason.RR_CHANGED_AVG_CPM to Reason.CHANGED_AVG_CPM,
            ERestartReason.RR_CHANGED_AVG_CPM_PERIOD to Reason.CHANGED_AVG_CPM_PERIOD,
            ERestartReason.RR_CHANGED_AVG_CPV to Reason.CHANGED_AVG_CPV,
            ERestartReason.RR_CHANGED_AVG_CPV_PERIOD to Reason.CHANGED_AVG_CPV_PERIOD,
            ERestartReason.RR_RESTART_AFTER_MONEY_PAUSE to Reason.RESTART_AFTER_MONEY_PAUSE,
            ERestartReason.RR_RESTART_AFTER_STOP_PAUSE to Reason.RESTART_AFTER_STOP_PAUSE,
            ERestartReason.RR_CPC_HOLD_ENABLED to Reason.CPC_HOLD_ENABLED,
            ERestartReason.RR_CHANGED_FINISH_TIME_TO_FUTURE to Reason.CHANGED_FINISH_TIME_TO_FUTURE,
            ERestartReason.RR_OLD_RESTART_FOR_PERIOD_CAMPAIGN to Reason.OLD_RESTART_FOR_PERIOD_CAMPAIGN,
            ERestartReason.RR_NET_CPC_OPTIMIZE_AFTER_DAY_BUDGET to Reason.NET_CPC_OPTIMIZE_AFTER_DAY_BUDGET,
            ERestartReason.RR_CHANGED_AVG_CPA to Reason.CHANGED_AVG_CPA,
            ERestartReason.RR_CHANGED_CPA_FOR_PAID_ACTIONS to Reason.CHANGED_CPA_FOR_PAID_ACTIONS,
        )

        private val autobudgetRestartReasonToGrutMapper =
            autobudgetRestartReasonFromGrutMapper.map { it.value to it.key }.toMap()

        fun autobudgetRestartReasonFromGrut(grutAutobudgetRestartReason: Int): Reason? {
            val reason = ERestartReason.forNumber(grutAutobudgetRestartReason)
            return autobudgetRestartReasonFromGrutMapper[reason]
        }

        fun autobudgetRestartReasonToGrut(reason: Reason): ERestartReason {
            return autobudgetRestartReasonToGrutMapper[reason] ?: ERestartReason.RR_UNKNOWN
        }

        private val RESTRICTION_TYPE_MAPPER =
            buildEnumMapping(InternalCampaignRestrictionType::class.java, CampaignV2.ERestrictionType::class.java)

        fun restrictionTypeToGrut(restrictionType: InternalCampaignRestrictionType): CampaignV2.ERestrictionType {
            return convert(RESTRICTION_TYPE_MAPPER, CampaignV2.ERestrictionType.RT_UNKNOWN, restrictionType)
        }

        private val RF_CLOSE_BY_CLICK_MAPPER =
            buildEnumMapping(RfCloseByClickType::class.java, CampaignV2.ERFCloseByClick::class.java)

        fun rfCloseByClickToGrut(rfCloseByClick: RfCloseByClickType): CampaignV2.ERFCloseByClick {
            return convert(RF_CLOSE_BY_CLICK_MAPPER, CampaignV2.ERFCloseByClick.RFCC_UNKNOWN, rfCloseByClick)
        }

        fun eshowsVideoTypeToGrut(eshowsVideoType: EshowsVideoType): CampaignV2.EShowVideoType {
            return when (eshowsVideoType) {
                EshowsVideoType.COMPLETES -> CampaignV2.EShowVideoType.EST_COMPLETES
                EshowsVideoType.LONG_CLICKS -> CampaignV2.EShowVideoType.EST_LONG_CLICKS
                else -> CampaignV2.EShowVideoType.EST_UNKNOWN
            }
        }
    }
}
