package ru.yandex.direct.mysql2grut.enummappers

import ru.yandex.direct.core.entity.creative.model.CreativeType
import ru.yandex.direct.core.entity.creative.model.SourceMediaType
import ru.yandex.grut.objects.proto.Creative
import ru.yandex.grut.objects.proto.Creative.TCreativeMetaBase.ECreativeType

class CreativeEnumMappers {
    companion object {
        private val CREATIVE_TYPE_MAPPER = mapOf(
            CreativeType.CANVAS to ECreativeType.CT_CANVAS,
            CreativeType.HTML5_CREATIVE to ECreativeType.CT_HTML5,
            CreativeType.VIDEO_ADDITION_CREATIVE to ECreativeType.CT_VIDEO_ADDITION,
            CreativeType.CPC_VIDEO_CREATIVE to ECreativeType.CT_CPC_VIDEO,
            CreativeType.CPM_VIDEO_CREATIVE to ECreativeType.CT_CPM_VIDEO,
            CreativeType.CPM_OUTDOOR_CREATIVE to ECreativeType.CT_CPM_OUTDOOR,
            CreativeType.CPM_INDOOR_CREATIVE to ECreativeType.CT_CPM_INDOOR,
            CreativeType.CPM_OVERLAY to ECreativeType.CT_CPM_OVERLAY,
            CreativeType.CPM_AUDIO_CREATIVE to ECreativeType.CT_CPM_AUDIO,
        )

        val CREATIVE_TYPE_BLACKLIST = setOf(
            CreativeType.PERFORMANCE,
            CreativeType.BANNERSTORAGE
        )

        fun toCreativeType(creativeType: CreativeType): ECreativeType {
            return convert(
                CREATIVE_TYPE_MAPPER,
                ECreativeType.CT_UNKNOWN,
                creativeType
            )
        }

        private val SOURCE_MEDIA_TYPE_MAPPER = buildEnumMapping(
            SourceMediaType::class.java, Creative.TCreativeSpec.EMediaType::class.java
        )

        fun sourceMediaTypeToGrut(sourceMediaType: SourceMediaType): Creative.TCreativeSpec.EMediaType {
            return convert(
                SOURCE_MEDIA_TYPE_MAPPER,
                Creative.TCreativeSpec.EMediaType.MT_UNKNOWN,
                sourceMediaType
            )
        }
    }
}
