package ru.yandex.direct.mysql2grut.enummappers

import ru.yandex.direct.core.entity.retargeting.model.ConditionType
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.core.entity.retargeting.model.GoalSource
import ru.yandex.direct.core.entity.retargeting.model.GoalType
import ru.yandex.direct.core.entity.retargeting.model.RuleType
import ru.yandex.grut.auxiliary.proto.RetargetingRule.TRetargetingRule.EGoalSource
import ru.yandex.grut.auxiliary.proto.RetargetingRule.TRetargetingRule.EGoalType
import ru.yandex.grut.auxiliary.proto.RetargetingRule.TRetargetingRule.EOperator
import ru.yandex.grut.objects.proto.RetargetingCondition.TRetargetingConditionMetaBase.ERetargetingConditionType

class RetargetingConditionEnumMappers {
    companion object Mappers {

        val RET_COND_MAP = mapOf(
            ConditionType.ab_segments to ERetargetingConditionType.RC_AB_SEGMENTS,
            ConditionType.brandsafety to ERetargetingConditionType.RC_BRANDSAFETY,
            ConditionType.dmp to ERetargetingConditionType.RC_UNKNOWN, // нигде в коде больше не используется
            ConditionType.content_categories to ERetargetingConditionType.RC_UNKNOWN, // нигде в коде больше не используется
            ConditionType.geo_segments to ERetargetingConditionType.RC_GEO_SEGMENTS,
            ConditionType.metrika_goals to ERetargetingConditionType.RC_METRIKA_GOALS,
            ConditionType.shortcuts to ERetargetingConditionType.RC_SHORTCUTS,
            ConditionType.interests to ERetargetingConditionType.RC_INTERESTS
        )

        fun toGrut(from: ConditionType): ERetargetingConditionType {
            return convert(RET_COND_MAP, ERetargetingConditionType.RC_UNKNOWN, from)
        }

        fun toGrut(type: RuleType) : EOperator {
            return when(type) {
                RuleType.ALL -> EOperator.RT_ALL
                RuleType.NOT -> EOperator.RT_NOT
                RuleType.OR -> EOperator.RT_ANY
            }
        }

        fun toGrutGoalSource(from: GoalType) : EGoalSource {
            return when(from.source) {
                GoalSource.CRYPTA -> EGoalSource.GS_CRYPTA
                GoalSource.DIRECT -> EGoalSource.GS_DIRECT
                GoalSource.METRIKA -> EGoalSource.GS_METRIKA
            }
        }

        private val GOAL_TYPE_MAPPER = buildEnumMapping(
            GoalType::class.java, EGoalType::class.java, customFromLiteralAccessor = { e: Enum<*> -> e.name.lowercase() }
        )

        fun toGrut(from: GoalType) : EGoalType {
            return convert(GOAL_TYPE_MAPPER, EGoalType.GT_UNKNOWN, from)
        }

    }
}
