package ru.yandex.direct.oneshot.core.configuration;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.dbutil.configuration.DbUtilConfiguration;

@Configuration
@Import({
        DbUtilConfiguration.class,
        CommonConfiguration.class
})
@ComponentScan(
        basePackages = "ru.yandex.direct.oneshot.core",
        excludeFilters = {
                @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION),
        }
)
public class OneshotCoreConfiguration {
}
