package ru.yandex.direct.oneshot.core.entity.oneshot;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.db.PpcProperty;
import ru.yandex.direct.env.EnvironmentType;

import static ru.yandex.direct.common.db.PpcPropertyNames.ONESHOT_APP_CURRENT_REVISION;

@Component
public class OneshotAppVersionProvider {
    private final EnvironmentType environmentType;
    private final PpcProperty<String> currentRevisionProp;

    public OneshotAppVersionProvider(PpcPropertiesSupport ppcPropertiesSupport, EnvironmentType environmentType) {
        this.environmentType = environmentType;
        currentRevisionProp = ppcPropertiesSupport.get(ONESHOT_APP_CURRENT_REVISION);
    }

    /**
     * Возвращает ревизию кода, из которой была собрана последняя версия приложения-ваншотилки
     * <p>
     * На разработческих средах возвращает {@code null}.
     */
    public String getCurrentRevision() {
        String lastRevision = currentRevisionProp.get();
        if (lastRevision == null) {
            return null;
        }
        if (environmentType.isBeta() || environmentType.isDevelopment()) {
            return null;
        }
        return lastRevision;
    }
}
