package ru.yandex.direct.rbac;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public interface RbacUserLookupService {
    Map<ClientId, Long> getChiefsByClientIds(Collection<ClientId> clientIds);

    /**
     * Получить шефов по коллекции ClientID
     *
     * @param clientIds коллекция id клиентов, представителей которых нужно получить
     * @param chunkSize размер чанка
     * @return мапа ClientID -> chiefUid
     */
    default Map<ClientId, Long> getChiefsByClientIds(Collection<ClientId> clientIds, int chunkSize) {
        Map<ClientId, Long> result = Maps.newHashMapWithExpectedSize(clientIds.size());
        for (List<ClientId> chunk : Iterables.partition(clientIds, chunkSize)) {
            result.putAll(getChiefsByClientIds(chunk));
        }
        return result;
    }

    @Nonnull
    Map<Long, RbacRole> getUidsRoles(Collection<Long> uids);
}
