package ru.yandex.direct.rbac;

import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Все данные из ClientPerminfo + тип представителя
 */
public class UserPerminfo extends ClientPerminfo {
    private final RbacRepType repType;
    private final Long uid;

    public UserPerminfo(ClientId clientId, Long chiefUid, RbacRole role,
                        RbacSubrole subrole, ClientId agencyClientId, Set<Long> agencyUids, Long managerUid,
                        Set<Long> clientManagers,
                        RbacRepType repType, Long uid, Set<ClientPerm> perms,
                        boolean canHaveRelationship, Set<Long> mccClientIds,
                        Set<Long> managerGroupIds, Set<Long> clientGroupIds) {
        super(clientId, chiefUid, role, subrole, agencyClientId, agencyUids, managerUid, clientManagers,
                perms, canHaveRelationship, mccClientIds, managerGroupIds, clientGroupIds);
        this.repType = repType != null ? repType : RbacRepType.MAIN;
        this.uid = uid;
    }

    @Nonnull
    public RbacRepType repType() {
        return repType;
    }

    @Nonnull
    public Boolean isReadonlyRep() {
        return repType == RbacRepType.READONLY;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserPerminfo that = (UserPerminfo) o;
        return repType == that.repType
                && uid.equals(that.uid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), repType, uid);
    }

    public Long userId() {
        return uid;
    }

    public boolean hasRepType(RbacRepType... expectedRepTypes) {
        for (RbacRepType expectedRepType : expectedRepTypes) {
            if (this.repType == expectedRepType) {
                return true;
            }
        }
        return false;
    }
}
