package ru.yandex.direct.rbac.cache;

import java.util.Collection;
import java.util.Map;

/**
 * Внутреннее кеширование данных RBAC
 * По-хорошему, лучше уметь обходиться без кеширования, но код уже написан так, что
 * в рамках одного запроса делается большое количество одинаковых запросов в RBAC.
 *
 * @param <K>
 * @param <V>
 */
public interface RbacCache<K, V> {
    /**
     * Получение данных из кеша, с загрузкой недостающих значений loader-ом
     *
     * @param keys
     * @param loader
     * @return
     */
    Map<K, V> computeIfAbsent(Collection<K> keys, CacheMassLoader<K, V> loader);

    /**
     * Почистить кеш, это стоит делать после изменений клиентских данных (роли/представители/...)
     */
    void clear();
}
