package ru.yandex.direct.rbac.cache;

import java.util.Collection;
import java.util.Map;

/**
 * Реализация кеша, которая реально ничего не кеширует
 *
 * @param <K>
 * @param <V>
 */
public class RbacNoopCache<K, V> implements RbacCache<K, V> {
    @Override
    public Map<K, V> computeIfAbsent(Collection<K> keys, CacheMassLoader<K, V> loader) {
        return loader.get(keys);
    }

    @Override
    public void clear() {
        // noop
    }
}
