package ru.yandex.direct.rbac.configuration;

import java.util.concurrent.TimeUnit;

import com.google.common.cache.CacheBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.dbutil.configuration.DbUtilConfiguration;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.ClientPerminfo;
import ru.yandex.direct.rbac.PpcRbac;
import ru.yandex.direct.rbac.UserPerminfo;
import ru.yandex.direct.rbac.cache.RbacCache;
import ru.yandex.direct.rbac.cache.RbacGuavaCache;
import ru.yandex.direct.rbac.model.ClientsRelation;
import ru.yandex.direct.rbac.model.RbacCampPerms;
import ru.yandex.direct.rbac.model.RelatedClients;

import static ru.yandex.direct.rbac.PpcRbac.CAMP_PERMS_CACHE_BEAN_NAME;
import static ru.yandex.direct.rbac.PpcRbac.CLIENTS_CACHE_BEAN_NAME;
import static ru.yandex.direct.rbac.PpcRbac.USERS_CACHE_BEAN_NAME;
import static ru.yandex.direct.rbac.RbacClientsRelations.RELATIONS_CACHE_BEAN_NAME;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.rbac",
        excludeFilters = {
                @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
        }
)
@Import({
        EssentialConfiguration.class,
        DbUtilConfiguration.class,
})
public class RbacConfiguration {
    @Bean(CLIENTS_CACHE_BEAN_NAME)
    RbacCache<ClientId, ClientPerminfo> clientsCache() {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder()
                .maximumSize(5_000)
                .expireAfterWrite(10, TimeUnit.SECONDS);
        return new RbacGuavaCache<>(cacheBuilder::build);
    }

    @Bean(USERS_CACHE_BEAN_NAME)
    RbacCache<Long, UserPerminfo> usersCache() {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder()
                .maximumSize(5_000)
                .expireAfterWrite(10, TimeUnit.SECONDS);
        return new RbacGuavaCache<>(cacheBuilder::build);
    }

    @Bean(CAMP_PERMS_CACHE_BEAN_NAME)
    RbacCache<PpcRbac.OperatorCampIds, RbacCampPerms> campCache() {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder()
                .maximumSize(5_000)
                .expireAfterWrite(30, TimeUnit.SECONDS);
        return new RbacGuavaCache<>(cacheBuilder::build);
    }

    @Bean(RELATIONS_CACHE_BEAN_NAME)
    RbacCache<RelatedClients, ClientsRelation> relationsCache() {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder()
                .maximumSize(5_000)
                .expireAfterWrite(10, TimeUnit.SECONDS);
        return new RbacGuavaCache<>(cacheBuilder::build);
    }
}
