package ru.yandex.direct.rbac.model;

import java.util.Objects;

/**
 * Связка клиентов
 */
public class ClientsRelation {
    private Long relationId;

    private Long clientIdFrom;

    private Long clientIdTo;

    private ClientsRelationType relationType;

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public ClientsRelation withRelationId(Long relationId) {
        this.relationId = relationId;
        return this;
    }

    public Long getClientIdFrom() {
        return clientIdFrom;
    }

    public void setClientIdFrom(Long clientIdFrom) {
        this.clientIdFrom = clientIdFrom;
    }

    public ClientsRelation withClientIdFrom(Long clientIdFrom) {
        setClientIdFrom(clientIdFrom);
        return this;
    }

    public Long getClientIdTo() {
        return clientIdTo;
    }

    public void setClientIdTo(Long clientIdTo) {
        this.clientIdTo = clientIdTo;
    }

    public ClientsRelation withClientIdTo(Long clientIdTo) {
        setClientIdTo(clientIdTo);
        return this;
    }

    public ClientsRelationType getRelationType() {
        return relationType;
    }

    public void setRelationType(ClientsRelationType relationType) {
        this.relationType = relationType;
    }

    public ClientsRelation withRelationType(ClientsRelationType relationType) {
        setRelationType(relationType);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.core.entity.client.model.ClientsRelation{");
        sb.append("clientIdFrom=").append(clientIdFrom);
        sb.append(", clientIdTo=").append(clientIdTo);
        sb.append(", relationType=").append(relationType);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClientsRelation
                that = (ClientsRelation) o;
        return Objects.equals(clientIdFrom, that.clientIdFrom)
                && Objects.equals(clientIdTo, that.clientIdTo)
                && Objects.equals(relationType, that.relationType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                clientIdFrom,
                clientIdTo,
                relationType
        );
    }
}
