package ru.yandex.direct.rbac.model;

/**
 * Тип доступа к пользователю.
 */
public enum RbacAccessType {

    READ_WRITE(true, true, true),
    READONLY(true, true, false),
    NONE(false, false, false);

    private boolean isOwner;
    private boolean canRead;
    private boolean canWrite;

    RbacAccessType(boolean isOwner, boolean canRead, boolean canWrite) {
        this.isOwner = isOwner;
        this.canRead = canRead;
        this.canWrite = canWrite;
    }

    public boolean isOwner() {
        return isOwner;
    }

    public boolean canRead() {
        return canRead;
    }

    public boolean canWrite() {
        return canWrite;
    }
}
