package ru.yandex.direct.rbac.model;

public class RbacCampPerms {
    public static final RbacCampPerms EMPTY = new RbacCampPerms(builder());
    public static final RbacCampPerms ALL = new RbacCampPerms(
            builder().withCanRead(true).withCanWrite(true).withCanDrop(true).withCanTransferMoney(true)
                    .withCanExportInExcel(true)
    );
    public static final RbacCampPerms WITHOUT_TRANSFER_MONEY = new RbacCampPerms(
            builder().withCanRead(true).withCanWrite(true).withCanDrop(true).withCanExportInExcel(true)
    );
    public static final RbacCampPerms READONLY = new RbacCampPerms(
            builder().withCanRead(true).withCanExportInExcel(true)
    );

    private final boolean canRead;
    private final boolean canWrite;
    private final boolean canDrop;
    private final boolean canTransferMoney;
    private final boolean canExportInExcel;

    public static Builder builder() {
        return new Builder();
    }

    private RbacCampPerms(Builder builder) {
        this.canRead = builder.canRead;
        this.canWrite = builder.canWrite;
        this.canDrop = builder.canDrop;
        this.canTransferMoney = builder.canTransferMoney;
        this.canExportInExcel = builder.canExportInExcel;
    }

    public boolean canRead() {
        return canRead;
    }

    public boolean canWrite() {
        return canWrite;
    }

    public boolean canDrop() {
        return canDrop;
    }

    public boolean canTransferMoney() {
        return canTransferMoney;
    }

    public boolean canExportInExcel() {
        return canExportInExcel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        RbacCampPerms that = (RbacCampPerms) o;

        if (canRead != that.canRead) {
            return false;
        }
        if (canWrite != that.canWrite) {
            return false;
        }
        if (canDrop != that.canDrop) {
            return false;
        }
        if (canExportInExcel != that.canExportInExcel) {
            return false;
        }
        return canTransferMoney == that.canTransferMoney;
    }

    @Override
    public int hashCode() {
        int result = (canRead ? 1 : 0);
        result = 31 * result + (canWrite ? 1 : 0);
        result = 31 * result + (canDrop ? 1 : 0);
        result = 31 * result + (canTransferMoney ? 1 : 0);
        result = 31 * result + (canExportInExcel ? 1 : 0);
        return result;
    }

    public static class Builder {
        private boolean canRead;
        private boolean canWrite;
        private boolean canDrop;
        private boolean canTransferMoney;
        private boolean canExportInExcel;

        public RbacCampPerms build() {
            return new RbacCampPerms(this);
        }

        public Builder withCanRead(boolean canRead) {
            this.canRead = canRead;
            return this;
        }

        public Builder withCanWrite(boolean canWrite) {
            this.canWrite = canWrite;
            return this;
        }

        public Builder withCanDrop(boolean canDrop) {
            this.canDrop = canDrop;
            return this;
        }

        public Builder withCanTransferMoney(boolean canTransferMoney) {
            this.canTransferMoney = canTransferMoney;
            return this;
        }

        public Builder withCanExportInExcel(boolean canExportInExcel) {
            this.canExportInExcel = canExportInExcel;
            return this;
        }
    }
}
