package ru.yandex.direct.rbac.model;

import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Клиенты с отношением (часть {@code ClientsRelation}).
 * Используется как ключ кеширования для {@code RbacClientsRelationsStorage}.
 *
 * @see ru.yandex.direct.rbac.RbacClientsRelationsStorage
 */
public class RelatedClients {

    private final ClientId from;
    private final ClientId to;

    public RelatedClients(ClientId from, ClientId to) {
        this.from = from;
        this.to = to;
    }

    public ClientId getFrom() {
        return from;
    }

    public ClientId getTo() {
        return to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedClients that = (RelatedClients) o;
        return Objects.equals(from, that.from) &&
                Objects.equals(to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(from, to);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
