package ru.yandex.direct.rbac.model;

import java.util.Objects;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacRepType;

public class Representative {
    private final ClientId clientId;
    private final long userId;
    private final boolean isChief;
    private final boolean isLimited;

    private final boolean isReadonly;

    private Representative(ClientId clientId, long userId, boolean isChief, boolean isLimited, boolean isReadonly) {
        this.clientId = clientId;
        this.userId = userId;
        this.isChief = isChief;
        this.isLimited = isLimited;
        this.isReadonly = isReadonly;
    }

    public static Representative create(ClientId clientId, long userId, RbacRepType repType) {
        boolean isChief = repType == RbacRepType.CHIEF;
        boolean isLimited = repType == RbacRepType.LIMITED;
        boolean isReadonly = repType == RbacRepType.READONLY;
        return new Representative(clientId, userId, isChief, isLimited, isReadonly);
    }

    public static Representative createChief(ClientId clientId, long userId) {
        return new Representative(clientId, userId, true, false, false);
    }

    public ClientId getClientId() {
        return clientId;
    }

    public long getUserId() {
        return userId;
    }

    public boolean isChief() {
        return isChief;
    }

    public boolean isLimited() {
        return isLimited;
    }

    public boolean isReadonly() {
        return isReadonly;
    }

    @Override
    public String toString() {
        return "Representative{" +
                "clientId=" + clientId +
                ", userId=" + userId +
                ", isChief=" + isChief +
                ", isLimited=" + isLimited +
                ", isReadonly=" + isReadonly +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Representative that = (Representative) o;
        return Objects.equals(clientId, that.clientId) &&
                userId == that.userId &&
                isChief == that.isChief &&
                isReadonly == that.isReadonly &&
                isLimited == that.isLimited;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(userId);
    }
}
