package ru.yandex.direct.rbac.model;

import java.util.Collections;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.ClientPerm;


@ParametersAreNonnullByDefault
public class SubclientGrants {
    private final Long agencyUid;
    private final ClientId clientId;
    private final Set<ClientPerm> permissions;

    private SubclientGrants(@Nullable Long agencyUid, ClientId clientId, Set<ClientPerm> permissions) {
        this.agencyUid = agencyUid;
        this.clientId = clientId;
        this.permissions = permissions;
    }

    public static SubclientGrants buildWithAllGrants(@Nullable Long agencyUid, ClientId clientId) {
        return new SubclientGrants(agencyUid, clientId, ImmutableSet.of(
                ClientPerm.SUPER_SUBCLIENT, ClientPerm.XLS_IMPORT, ClientPerm.MONEY_TRANSFER));
    }

    public static SubclientGrants buildWithPermissions(@Nullable Long agencyUid, ClientId clientId,
                                                       Set<ClientPerm> permissions) {
        return new SubclientGrants(agencyUid, clientId, Collections.unmodifiableSet(permissions));
    }

    @Nullable
    public Long getAgencyUid() {
        return agencyUid;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public boolean canCreateCampaign() {
        return permissions.contains(ClientPerm.SUPER_SUBCLIENT);
    }

    public boolean canImportXLS() {
        return permissions.contains(ClientPerm.XLS_IMPORT);
    }

    public boolean canToTransferMoney() {
        return permissions.contains(ClientPerm.MONEY_TRANSFER);
    }
}
