package ru.yandex.direct.samovar.logbroker;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import NCrawl.Feeds;

import ru.yandex.direct.binlogbroker.logbroker_utils.writer.AbstractLogbrokerWriterImpl;
import ru.yandex.direct.binlogbroker.logbroker_utils.writer.LogbrokerWriterRetryConfig;
import ru.yandex.kikimr.persqueue.producer.AsyncProducer;

public class ExternalFeedMessagesLogbrokerWriter extends AbstractLogbrokerWriterImpl<Feeds.TFeedExt> {

    public ExternalFeedMessagesLogbrokerWriter(Supplier<CompletableFuture<AsyncProducer>> logbrokerProducerSupplier,
                                       Duration logbrokerTimeout, int retryCount) {
        super(logbrokerProducerSupplier, logbrokerTimeout, new LogbrokerWriterRetryConfig(retryCount), true);
    }

    @Override
    protected AbstractLogbrokerWriterImpl<Feeds.TFeedExt>.LogbrokerWriteRequest makeRequest(Feeds.TFeedExt record) {
        return new LogbrokerWriteRequest(record.toByteArray());
    }
}
