package ru.yandex.direct.samovar.logbroker;

import java.time.Duration;

import NCrawl.Feeds;

import ru.yandex.direct.binlogbroker.logbroker_utils.writer.LogbrokerWriter;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerPropertiesImpl;
import ru.yandex.kikimr.persqueue.compression.CompressionCodec;

public class ExternalFeedMessagesLogbrokerWriterFactory {
    private static final String SOURCE_ID = "direct-offers-preview-update";

    private final LogbrokerClientFactoryFacade logbrokerClientFactoryFacade;
    private final SamovarLogbrokerConfig config;

    public ExternalFeedMessagesLogbrokerWriterFactory(LogbrokerClientFactoryFacade logbrokerClientFactoryFacade,
                                                      DirectConfig directConfig) {
        this.logbrokerClientFactoryFacade = logbrokerClientFactoryFacade;
        var samovarLogbrokerBranch = directConfig.getBranch("samovar.logbroker");
        this.config = new SamovarLogbrokerConfig()
                .setWriteTopic(samovarLogbrokerBranch.getString("topic"))
                .setRetries(samovarLogbrokerBranch.getInt("retries"))
                .setHost(samovarLogbrokerBranch.getString("host"))
                .setTimeout(samovarLogbrokerBranch.getDuration("timeout"))
                .setCompressionCodec(CompressionCodec.GZIP);
    }

    public LogbrokerWriter<Feeds.TFeedExt> getWriter() {
        var logbrokerProducerProperties = LogbrokerProducerPropertiesImpl.newBuilder()
                .setCompressionCodec(config.compressionCodec)
                .setTimeoutSec(config.timeout.getSeconds())
                .setHost(config.host)
                .setWriteTopic(config.writeTopic)
                .setRetries(config.retries)
                .setGroup(0)
                .build();
        var producerSupplier = logbrokerClientFactoryFacade.createProducerSupplier(logbrokerProducerProperties,
                SOURCE_ID);
        return new ExternalFeedMessagesLogbrokerWriter(producerSupplier, config.timeout, config.retries);
    }

    private static class SamovarLogbrokerConfig {
        private String writeTopic;
        private String host;
        private Duration timeout;
        private int retries;
        private CompressionCodec compressionCodec;

        public SamovarLogbrokerConfig setWriteTopic(String writeTopic) {
            this.writeTopic = writeTopic;
            return this;
        }

        public SamovarLogbrokerConfig setHost(String host) {
            this.host = host;
            return this;
        }

        public SamovarLogbrokerConfig setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SamovarLogbrokerConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public SamovarLogbrokerConfig setCompressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }
    }
}
