package ru.yandex.direct.screenshooter.client.configuration;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.asynchttpclient.AsyncHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.asynchttp.FetcherSettings;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.avatars.client.AvatarsClient;
import ru.yandex.direct.avatars.config.AvatarsConfig;
import ru.yandex.direct.avatars.config.ServerConfig;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.integrations.configuration.IntegrationsConfiguration;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.screenshooter",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({IntegrationsConfiguration.class})
@ParametersAreNonnullByDefault
public class ScreenShooterConfiguration {
    private static final String AVATARS_CLIENT = "avatarsScreenShooterClient";

    @Bean(name = AVATARS_CLIENT)
    @Lazy
    AvatarsClient avatarsClient(DirectConfig directConfig, AsyncHttpClient asyncHttpClient) {
        DirectConfig avatarsConfig = directConfig.getBranch("screenshooter_client").getBranch("avatars");

        AvatarsConfig avatarsClientConfig = new AvatarsConfig(
                avatarsConfig.getString("name"),
                new ServerConfig(
                        avatarsConfig.getString("read_server_host"),
                        avatarsConfig.getInt("read_server_port"),
                        avatarsConfig.getString("read_server_schema")),
                new ServerConfig(
                        avatarsConfig.getString("write_server_host"),
                        avatarsConfig.getInt("write_server_port"),
                        avatarsConfig.getString("write_server_schema")),
                avatarsConfig.getDuration("write_timeout"),
                avatarsConfig.getString("upload_namespace"),
                avatarsConfig.findBoolean("prioritypass").orElse(false));

        Duration connectTimeout = avatarsConfig.getDuration("connect_timeout");
        FetcherSettings fetcherSettings = new FetcherSettings().withConnectTimeout(connectTimeout);
        ParallelFetcherFactory parallelFetcherFactory =
                new ParallelFetcherFactory(asyncHttpClient, fetcherSettings);

        return new AvatarsClient(avatarsClientConfig, parallelFetcherFactory, null, null);
    }
}

