package ru.yandex.direct.screenshooter.client.model;

public class ScreenShooterScreenshot {
    private String url; // ссылка на orig изображение

    private String urlMainBanner;//основной баннер для расхлопа. Нужен отдельный скриншот

    private ScreenShooterSizesInfo sizes;

    private Boolean isDone;

    private byte[] imageData;

    public String getUrl() {
        return url;
    }

    public ScreenShooterScreenshot withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getUrlMainBanner() {
        return urlMainBanner;
    }

    public ScreenShooterScreenshot withUrlMainBanner(String urlMainBanner) {
        this.urlMainBanner = urlMainBanner;
        return this;
    }

    public ScreenShooterSizesInfo getSizes() {
        return sizes;
    }

    public ScreenShooterScreenshot withSizes(ScreenShooterSizesInfo sizes) {
        this.sizes = sizes;
        return this;
    }

    public Boolean getIsDone() {
        return isDone;
    }

    public ScreenShooterScreenshot withIsDone(Boolean isDone) {
        this.isDone = isDone;
        return this;
    }

    public byte[] getImageData() {
        return imageData;
    }

    public ScreenShooterScreenshot withImageData(byte[] imageData) {
        this.imageData = imageData;
        return this;
    }

    @Override
    public String toString() {
        return "ScreenShooterScreenshot{" +
                "url=" + url +
                ", urlMainBanner=" + urlMainBanner +
                ", sizes=" + sizes +
                ", isDone=" + isDone +
                '}';
    }
}
