package ru.yandex.direct.http.smart.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * <li>
 * Если указана над методом, то результат будет конвертироваться из
 * {@link ru.yandex.direct.http.smart.request.Content} используя
 * {@link ru.yandex.direct.http.smart.converter.ProtoAsJsonResponseConverter}
 * </li>
 * <li>
 * Если указана над параметром, то этот параметр будет конвертироваться в
 * {@link ru.yandex.direct.http.smart.request.Content} используя
 * {@link ru.yandex.direct.http.smart.converter.ProtoAsJsonRequestConverter}
 * </li>
 */
@Documented
@Target({METHOD, PARAMETER})
@Retention(RUNTIME)
public @interface ProtoAsJson {
}
