package ru.yandex.direct.http.smart.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import ru.yandex.direct.http.smart.converter.DefaultResponseChecker;
import ru.yandex.direct.http.smart.converter.ResponseChecker;
import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.direct.http.smart.converter.StringResponseConverter;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Указывает, как обрабатывать результат запроса
 */
@Documented
@Target({METHOD})
@Retention(RUNTIME)
public @interface ResponseHandler {
    /**
     * Класс, который отвечает за преобразование строки в результирующий объект.
     * Объект должен быть зарегистрирован в {@link ru.yandex.direct.http.smart.converter.ResponseConverterFactory}
     */
    Class<? extends ResponseConverter> parserClass() default StringResponseConverter.class;

    /**
     * Класс, который отвечает за проверку ответа на пригодность к парсингу
     * Объект должен быть зарегистрирован в {@link ru.yandex.direct.http.smart.converter.ResponseConverterFactory}
     */
    Class<? extends ResponseChecker> checkerClass() default DefaultResponseChecker.class;

    /**
     * Если указан без {@link #checkerClass()}, будет пригодность к парсингу будет проверена только по коду ответа http
     */
    int[] expectedCodes() default 200;
}
