package ru.yandex.direct.http.smart.converter;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

import com.fasterxml.jackson.databind.JavaType;
import org.asynchttpclient.Response;

import ru.yandex.direct.utils.JsonUtils;

public final class JsonResponseConverter implements ResponseConverter<Object> {
    @Override
    public Object convert(Response response, Type responseType) {
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
        JavaType javaType = JsonUtils.MAPPER.getTypeFactory().constructType(responseType);
        return JsonUtils.fromJson(responseBody, javaType);
    }
}
