package ru.yandex.direct.http.smart.converter;

import java.io.File;
import java.nio.charset.Charset;

import javax.annotation.Nullable;

import org.apache.commons.lang3.reflect.TypeUtils;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.PartBase;
import org.asynchttpclient.request.body.multipart.StringPart;

public class PartConverter<T> {
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final String CONTENT_TYPE = "text/plain";
    private String name;
    private final RequestBodyConverter<T> stringConverter;

    public PartConverter(RequestBodyConverter<T> stringConverter, @Nullable String name) {
        this.stringConverter = stringConverter;
        this.name = name;
    }

    public PartBase convert(@Nullable String name, T value, String encoding) {
        if (name == null) {
            name = this.name;
        }
        PartBase part;
        if (TypeUtils.isAssignable(value.getClass(), File.class)) {
            part = new FilePart(name, (File) value, CONTENT_TYPE, CHARSET, null, null, encoding);
        } else if (TypeUtils.isAssignable(value.getClass(), byte[].class)) {
            part = new ByteArrayPart(name, (byte[]) value, CONTENT_TYPE, CHARSET, null, null, encoding);
        } else {
            part = new StringPart(name, stringConverter.convert(value).asString(),
                    CONTENT_TYPE, CHARSET, null, encoding);
        }
        return part;
    }
}
