package ru.yandex.direct.http.smart.converter;

import java.util.ArrayList;
import java.util.stream.Collectors;

import ru.yandex.direct.http.smart.request.Content;
import ru.yandex.direct.http.smart.request.StringContent;
import ru.yandex.direct.utils.JsonUtils;

public class ProtoAsJsonRequestConverter implements RequestBodyConverter<Object> {
    @Override
    public Content convert(Object value) {
        Content result;
        if (value instanceof Iterable) {
            var req = new ArrayList<String>();
            for (Object o : (Iterable<?>) value) {
                req.add(JsonUtils.toJson(o));
            }
            result = new StringContent(req.stream().collect(Collectors.joining(",", "[", "]")));
        } else {
            result = new StringContent(JsonUtils.toJson(value));
        }
        return result;
    }
}
