package ru.yandex.direct.http.smart.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.google.protobuf.Message;

import ru.yandex.direct.http.smart.request.ByteContent;
import ru.yandex.direct.http.smart.request.Content;

public class ProtoRequestConverter<T> implements RequestBodyConverter<T> {

    @Override
    public Content convert(T value) {
        if (value instanceof Iterable) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                for (Message m : (Iterable<Message>) value) {
                    m.writeDelimitedTo(stream);
                }
            } catch (IOException e) {
                throw new IllegalArgumentException("Failed to serialize protobuf body", e);
            }
            return new ByteContent(stream.toByteArray());
        } else {
            return new ByteContent(((Message) value).toByteArray());
        }
    }
}
