package ru.yandex.direct.http.smart.converter;

import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;

import ru.yandex.direct.http.smart.request.Content;
import ru.yandex.direct.http.smart.request.StringContent;


public final class XmlRequestConverter<T> implements RequestBodyConverter<T> {
    private final ObjectMapper xmlMapper = new XmlMapper();

    @Override
    public Content convert(T value) {
        try {
            return new StringContent(xmlMapper.writeValueAsString(value));
        } catch (IOException e) {
            throw new IllegalArgumentException("can not serialize object to xml", e);
        }
    }
}
