package ru.yandex.direct.http.smart.converter;

import java.io.IOException;
import java.lang.reflect.Type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.asynchttpclient.Response;

public final class XmlResponseConverter implements ResponseConverter<Object> {
    private final ObjectMapper xmlMapper = new XmlMapper();

    @Override
    public Object convert(Response response, Type responseType) {
        JavaType javaType = xmlMapper.getTypeFactory().constructType(responseType);
        try {
            return xmlMapper.readValue(response.getResponseBody(), javaType);
        } catch (IOException e) {
            throw new IllegalArgumentException("can not deserialize xml to object", e);
        }
    }
}
