package ru.yandex.direct.http.smart.core;

import ru.yandex.direct.asynchttp.FetcherSettings;
import ru.yandex.direct.asynchttp.ParallelFetcher;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.ParsableRequest;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceChild;
import ru.yandex.direct.tracing.TraceProfile;
import ru.yandex.direct.utils.InterruptedRuntimeException;

import static ru.yandex.direct.solomon.SolomonUtils.getParallelFetcherMetricRegistry;
import static ru.yandex.direct.tracing.util.TraceUtil.X_YANDEX_TRACE;
import static ru.yandex.direct.tracing.util.TraceUtil.traceToHeader;

public class Call<R> extends AbstractCall<R> {
    protected ParsableRequest<R> request;

    public Call(ServiceMethod<R> serviceMethod, ParallelFetcherFactory parallelFetcherFactory,
                SmartRequestBuilder requestBuilder) {
        super(serviceMethod, parallelFetcherFactory, requestBuilder);
    }

    public ParsableRequest<R> getRequest() {
        if (request == null) {
            request = super.getRequest();
        }
        return request;
    }

    public Result<R> execute() {
        return executeInternal(null);
    }

    public Result<R> execute(FetcherSettings overrideFetcherSettings) {
        return executeInternal(overrideFetcherSettings);
    }

    private Result<R> executeInternal(FetcherSettings overrideFetcherSettings) {
        Result<R> result;
        try (TraceProfile profile = Trace.current().profile(traceFunc, "smart_client");
             TraceChild child = Trace.current().child(serviceMethod.smart.profileName, serviceMethod.methodName);
             ParallelFetcher<R> parallelFetcher = (overrideFetcherSettings == null) ?
                     parallelFetcherFactory.getParallelFetcherWithMetricRegistry(
                             getParallelFetcherMetricRegistry(profile.getFunc())) :
                     parallelFetcherFactory.getParallelFetcher(overrideFetcherSettings.getMetricRegistry() == null ?
                             new FetcherSettings(overrideFetcherSettings)
                                     .withMetricRegistry(getParallelFetcherMetricRegistry(profile.getFunc())) :
                             overrideFetcherSettings)) {

            requestBuilder.addHeader(X_YANDEX_TRACE, traceToHeader(child));
            result = parallelFetcher.execute(getRequest());
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedRuntimeException(e);
        }
        return result;
    }

}
