package ru.yandex.direct.http.smart.http;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.converter.RequestConverterFactory;
import ru.yandex.direct.http.smart.converter.StringRequestConverter;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Target(PARAMETER)
@Retention(RUNTIME)
public @interface Body {
    /**
     * Класс, который отвечает за преобразование параметра в тело запроса.
     * Объект должен быть зарегистрирован в {@link RequestConverterFactory}
     */
    Class<? extends RequestBodyConverter> converter() default StringRequestConverter.class;
}
