package ru.yandex.direct.http.smart.http;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import ru.yandex.direct.http.smart.core.CallsPack;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Аналог @Query. Этой аннотацией помечается аргумент, по которому планируется распаралелить запрос.
 * Подробнее можно посмотреть в {@link CallsPack}.
 */
@Documented
@Target(PARAMETER)
@Retention(RUNTIME)
public @interface PartibleQuery {
    String value();
}
