package ru.yandex.direct.http.smart.parameters;

import java.lang.reflect.Array;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class ArrayParameterHandler<T> implements ParameterHandler<Object> {
    private final ParameterHandler<T> parameterHandler;

    public ArrayParameterHandler(ParameterHandler<T> parameterHandler) {
        this.parameterHandler = parameterHandler;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable Object values) {
        if (values == null) {
            return;
        }

        for (int i = 0, size = Array.getLength(values); i < size; i++) {
            //noinspection unchecked
            parameterHandler.apply(builder, (T) Array.get(values, i));
        }
    }
}
