package ru.yandex.direct.http.smart.parameters;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;

import javax.annotation.Nullable;

import org.apache.commons.lang3.reflect.TypeUtils;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;
import ru.yandex.direct.http.smart.request.ByteContent;
import ru.yandex.direct.http.smart.request.StringContent;

public class BodyParameterHandler<T> implements ParameterHandler<T> {
    private final RequestBodyConverter<T> converter;
    private final Type bodyType;

    public BodyParameterHandler(Type bodyType, RequestBodyConverter<T> converter) {
        this.bodyType = bodyType;
        this.converter = converter;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable T value) {
        if (value == null) {
            throw new IllegalArgumentException("Body parameter value must not be null.");
        }

        if (TypeUtils.isAssignable(bodyType, File.class)) {
            builder.setBody((File) value);
            return;
        } else if (TypeUtils.isAssignable(bodyType, byte[].class)) {
            builder.setBody((byte[]) value);
            return;
        } else if (TypeUtils.isAssignable(bodyType, InputStream.class)) {
            builder.setBody((InputStream) value);
            return;
        }
        var body = converter.convert(value);
        if (body instanceof ByteContent) {
            builder.setBody(body.asBytes());
        }
        if (body instanceof StringContent) {
            builder.setBody(body.asString());
        }
    }
}
