package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import io.netty.handler.codec.http.cookie.DefaultCookie;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

import static com.google.common.base.Preconditions.checkNotNull;

public class CookieParameterHandler<T> implements ParameterHandler<T> {
    private final String name;
    private final RequestBodyConverter<T> valueConverter;

    public CookieParameterHandler(String name, RequestBodyConverter<T> valueConverter) {
        this.name = checkNotNull(name, "name == null");
        this.valueConverter = valueConverter;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable T value) {
        if (value == null) {
            return;
        }
        builder.addCookie(new DefaultCookie(name, valueConverter.convert(value).asString()));
    }
}
