package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class IterableParameterHandler<T> implements ParameterHandler<Iterable<T>> {
    private final ParameterHandler<T> parameterHandler;

    public IterableParameterHandler(ParameterHandler<T> parameterHandler) {
        this.parameterHandler = parameterHandler;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable Iterable<T> values) {
        if (values == null) {
            return;
        }

        for (T value : values) {
            parameterHandler.apply(builder, value);
        }
    }
}
