package ru.yandex.direct.http.smart.parameters;

import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.converter.PartConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class PartMapParameterHandler<T> implements ParameterHandler<Map<String, T>> {
    private final PartConverter<T> partConverter;
    private final String transferEncoding;

    public PartMapParameterHandler(PartConverter<T> partConverter, String transferEncoding) {
        this.partConverter = partConverter;
        this.transferEncoding = transferEncoding;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable Map<String, T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Part map was null.");
        }

        for (Map.Entry<String, T> entry : value.entrySet()) {
            String entryKey = entry.getKey();
            if (entryKey == null) {
                throw new IllegalArgumentException("Part map contained null key.");
            }
            T entryValue = entry.getValue();
            if (entryValue == null) {
                throw new IllegalArgumentException(
                        "Part map contained null value for key '" + entryKey + "'.");
            }
//            builder.addHeader("Content-Disposition", "form-data; name=\"" + entryKey + "\"");
//            builder.addHeader("Content-Transfer-Encoding", transferEncoding);
            builder.addBodyPart(partConverter.convert(entryKey, entryValue, transferEncoding));
        }
    }
}
