package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import org.asynchttpclient.request.body.multipart.PartBase;

import ru.yandex.direct.http.smart.converter.PartConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class PartParameterHandler<T> implements ParameterHandler<T> {
    private final PartConverter<T> converter;
    private final String encoding;

    public PartParameterHandler(PartConverter<T> converter, String encoding) {
        this.converter = converter;
        this.encoding = encoding;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable T value) {
        if (value == null) {
            return;
        }
        PartBase bodyPart = converter.convert(null, value, encoding);

        builder.addBodyPart(bodyPart);
    }
}
