package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

import static com.google.common.base.Preconditions.checkNotNull;

public class PartibleQueryParameterHandler<T> implements ParameterHandler<T> {
    private final String name;
    private final RequestBodyConverter<T> valueConverter;

    public PartibleQueryParameterHandler(String name, RequestBodyConverter<T> valueConverter) {
        this.name = checkNotNull(name, "name == null");
        this.valueConverter = valueConverter;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable T value) {
        if (value == null) {
            return;
        }
        builder.addPartibleQueryParam(name, valueConverter.convert(value).asString());
    }
}
