package ru.yandex.direct.http.smart.parameters;

import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class QueryMapParameterHandler<T> implements ParameterHandler<Map<String, T>> {
    private final RequestBodyConverter<T> valueConverter;

    public QueryMapParameterHandler(RequestBodyConverter<T> valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable Map<String, T> value) {
        if (value == null) {
            throw new IllegalArgumentException("Query map was null.");
        }

        for (Map.Entry<String, T> entry : value.entrySet()) {
            String entryKey = entry.getKey();
            if (entryKey == null) {
                throw new IllegalArgumentException("Query map contained null key.");
            }
            T entryValue = entry.getValue();
            if (entryValue == null) {
                throw new IllegalArgumentException(
                        "Query map contained null value for key '" + entryKey + "'.");
            }

            String convertedEntryValue = valueConverter.convert(entryValue).asString();
            if (convertedEntryValue == null) {
                throw new IllegalArgumentException("Query map value '"
                        + entryValue
                        + "' converted to null by "
                        + valueConverter.getClass().getName()
                        + " for key '"
                        + entryKey
                        + "'.");
            }

            builder.addQueryParam(entryKey, convertedEntryValue);
        }
    }
}
