package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.converter.RequestBodyConverter;
import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

public class QueryNameParameterHandler<T> implements ParameterHandler<T> {
    private final RequestBodyConverter<T> nameConverter;

    public QueryNameParameterHandler(RequestBodyConverter<T> nameConverter) {
        this.nameConverter = nameConverter;
    }

    @Override
    public void apply(SmartRequestBuilder builder, @Nullable T value) {
        if (value == null) {
            return;
        }
        builder.addQueryParam(nameConverter.convert(value).asString(), null);
    }
}
