package ru.yandex.direct.http.smart.parameters;

import javax.annotation.Nullable;

import ru.yandex.direct.http.smart.core.SmartRequestBuilder;

import static com.google.common.base.Preconditions.checkNotNull;

public class RelativeUrlParameterHandler implements ParameterHandler<Object> {
    @Override
    public void apply(SmartRequestBuilder builder, @Nullable Object value) {
        checkNotNull(value, "@Url parameter is null.");
        builder.setRelativeUrl(String.valueOf(value));
    }
}
