package ru.yandex.direct.http.smart.reflection;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

import static ru.yandex.direct.http.smart.reflection.Utils.EMPTY_TYPE_ARRAY;
import static ru.yandex.direct.http.smart.reflection.Utils.checkNotPrimitive;
import static ru.yandex.direct.http.smart.reflection.Utils.typeToString;

final class WildcardTypeImpl implements WildcardType {
    private final Type upperBound;
    private final Type lowerBound;

    WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
        if (lowerBounds.length > 1) {
            throw new IllegalArgumentException();
        }
        if (upperBounds.length != 1) {
            throw new IllegalArgumentException();
        }

        if (lowerBounds.length == 1) {
            if (lowerBounds[0] == null) {
                throw new NullPointerException();
            }
            checkNotPrimitive(lowerBounds[0]);
            if (upperBounds[0] != Object.class) {
                throw new IllegalArgumentException();
            }
            this.lowerBound = lowerBounds[0];
            this.upperBound = Object.class;
        } else {
            if (upperBounds[0] == null) {
                throw new NullPointerException();
            }
            checkNotPrimitive(upperBounds[0]);
            this.lowerBound = null;
            this.upperBound = upperBounds[0];
        }
    }

    @Override
    public Type[] getUpperBounds() {
        return new Type[]{upperBound};
    }

    @Override
    public Type[] getLowerBounds() {
        return lowerBound != null ? new Type[]{lowerBound} : EMPTY_TYPE_ARRAY;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof WildcardType && Utils.equals(this, (WildcardType) other);
    }

    @Override
    public int hashCode() {
        // This equals Arrays.hashCode(getLowerBounds()) ^ Arrays.hashCode(getUpperBounds()).
        return (lowerBound != null ? 31 + lowerBound.hashCode() : 1) ^ (31 + upperBound.hashCode());
    }

    @Override
    public String toString() {
        if (lowerBound != null) {
            return "? super " + typeToString(lowerBound);
        }
        if (upperBound == Object.class) {
            return "?";
        }
        return "? extends " + typeToString(upperBound);
    }
}
