package ru.yandex.direct.traceinterception.configuration;

import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.config.EssentialConfiguration;
import ru.yandex.direct.dbutil.configuration.DbUtilConfiguration;

@Configuration
@Import(value = {
        EssentialConfiguration.class,
        DbUtilConfiguration.class,
})
@ComponentScan(
        basePackages = "ru.yandex.direct.traceinterception",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
public class TraceInterceptionConfiguration {
}
