package ru.yandex.direct.traceinterception.entity.traceinterception.service;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Suppliers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.direct.traceinterception.entity.traceinterception.repository.TraceInterceptionsRepository;
import ru.yandex.direct.traceinterception.model.TraceInterception;

/**
 * Кэш для правил перехвата трейсинга.
 */
@Service
@ParametersAreNonnullByDefault
public class TraceInterceptionsCache {
    private final TraceInterceptionsRepository traceInterceptionsRepository;
    private final long reloadIntervalMS;

    // кэш полного списка правил перехвата
    private volatile Supplier<List<TraceInterception>> traceInterceptionsSupplier;

    @Autowired
    public TraceInterceptionsCache(TraceInterceptionsRepository traceInterceptionsRepository,
                                   @Value("${trace.interceptions.cacheReloadIntervalInMs:30000}") long reloadIntervalMS) {
        this.traceInterceptionsRepository = traceInterceptionsRepository;
        this.reloadIntervalMS = reloadIntervalMS;
        invalidateInterceptionsList();
    }

    /**
     * Инвалидирует кэш при изменении в базе данных правил перехвата.
     */
    public void invalidateInterceptionsList() {
        this.traceInterceptionsSupplier = Suppliers.memoizeWithExpiration(
                this::getAllData,
                reloadIntervalMS,
                TimeUnit.MILLISECONDS);
    }

    private List<TraceInterception> getAllData() {
        return traceInterceptionsRepository.getAll();
    }

    public List<TraceInterception> getTraceInterceptionsCached() {
        return traceInterceptionsSupplier.get();
    }
}
