package ru.yandex.direct.traceinterception.entity.traceinterception.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.traceinterception.entity.traceinterception.repository.TraceInterceptionsRepository;
import ru.yandex.direct.traceinterception.model.TraceInterception;
import ru.yandex.direct.traceinterception.model.TraceInterceptionAction;
import ru.yandex.direct.traceinterception.model.TraceInterceptionStatus;

@Service
@ParametersAreNonnullByDefault
public class TraceInterceptionsManagingService {
    private final TraceInterceptionsRepository traceInterceptionsRepository;

    private final TraceInterceptionsCache traceInterceptionsCache;

    public TraceInterceptionsManagingService(TraceInterceptionsRepository traceInterceptionsRepository,
                                             TraceInterceptionsCache traceInterceptionsCache) {
        this.traceInterceptionsRepository = traceInterceptionsRepository;
        this.traceInterceptionsCache = traceInterceptionsCache;
    }

    public List<TraceInterception> getAll() {
        return traceInterceptionsRepository.getAll();
    }

    public void add(TraceInterception traceInterception) {
        traceInterceptionsRepository.add(traceInterception);
        traceInterceptionsCache.invalidateInterceptionsList();
    }

    public List<TraceInterception> getCached() {
        return traceInterceptionsCache.getTraceInterceptionsCached();
    }

    public boolean updateInterceptionWithActionById(Long id, TraceInterceptionAction action) {
        boolean updated = traceInterceptionsRepository.updateActionById(id, action);
        traceInterceptionsCache.invalidateInterceptionsList();
        return updated;
    }

    public boolean updateInterceptionWithStatusById(Long id, TraceInterceptionStatus status) {
        boolean updated = traceInterceptionsRepository.updateStatusById(id, status);
        traceInterceptionsCache.invalidateInterceptionsList();
        return updated;
    }

    public boolean removeInterceptionById(Long id) {
        boolean removed = traceInterceptionsRepository.delete(id);
        traceInterceptionsCache.invalidateInterceptionsList();
        return removed;
    }
}
